## R has a predefined dataset with the name "iris"
  # To know more about the dataset type "?iris" in the console

# 1) Normalizing data
  Data <- iris
  Data[,1:4] <- as.data.frame(scale(iris[,1:4]))
  
# 2) Labelling species
  Data$Species <- as.integer(factor(Data$Species))
  
# 3) Creating a Linear Regression model and predicting values
  Model <- lm(Species~Sepal.Length+Sepal.Width+Petal.Length+Petal.Width, Data)
  
# 4) Checking Heteroscedasticity using the Breusch-Pagan test
  # Run the following command after removing "#" if "lmtest" library is not installed
  # install.packages("lmtest")
  library(lmtest)
  # Test for Heteroskedasticity
  bptest(Model)
  
# 5) Checking Multicollinearity 
  # Run the following command after removing "#" if "car" library is not installed
  # install.packages("car")
  library(car)
  # Calculating Variance Inflation
  vif(Model)
  
# 6) Checking Autocorrelation 
  # Autocorrelation is checked for the residuals of Linear model
  AutoCorrelation <- acf(Model$residuals, plot = FALSE)
  plot(AutoCorrelation, main = "ACF for Model Residuals")